package mole.state 
{
	import flash.geom.Point;
	import flash.media.Video;
	import mole.entities.characters.CMole;
	import mole.entities.controlers.CPlayerControler;
	import mole.entities.controlers.CPlayerControler2;
	import mole.entities.controlers.CPlayerControler3;
	import mole.entities.controlers.CPlayerControler4;
	import mole.entities.controlers.IControler;
	import net.flashpunk.Entity;
	import net.flashpunk.graphics.Image;
	import mole.Main;
	import mole.entities.CBackground;
	import mole.entities.particles.CParticleEmitter;
	import mole.CSoundAssets;
	import net.flashpunk.graphics.Text;
	import net.flashpunk.Sfx;
	import net.flashpunk.utils.Input;
	import net.flashpunk.utils.Key;
	
	
	/**
	 * Ecran d'accueil.
	 * @author Cédric Liaudet
	 */
	public class CMenu extends Entity implements IState 
	{
		[Embed(source = '../../data/sounds/Voice_Intro.mp3')]
		private const VOICE_INTRO:Class;
		
		[Embed(source = '../../data/images/titre.png')]
		private const BACKGROUND:Class;
		
		[Embed(source = '../../data/images/credtis.png')]
		private const CREDITS:Class;
		
		[Embed(source = '../../data/images/howto.png')]
		private const HOWTO:Class;
		
		[Embed(source='../../data/images/player_number.png')]
		private const NB_PLAYER:Class;
		
		[Embed(source='../../data/images/choose_player.png')]
		private const CHOOSE_PLAYER:Class;
		
		[Embed(source = '../../data/images/P1.png')]
		private const P1_BUTTON:Class;
		[Embed(source = '../../data/images/P2.png')]
		private const P2_BUTTON:Class;
		[Embed(source = '../../data/images/P3.png')]
		private const P3_BUTTON:Class;
		[Embed(source = '../../data/images/P4.png')]
		private const P4_BUTTON:Class;
		
		
		//[Embed(source = '../../data/images/Didou.png')]
		//private const DIDOU:Class;
		
		//[Embed(source = '../../data/images/Fab.png')]
		//private const FAB:Class;
		
		//[Embed(source = '../../data/images/Nono.png')]
		//private const NONO:Class;
		
		//[Embed(source = '../../data/images/Ced.png')]
		//private const CED:Class;
		
		[Embed(source='../../data/sounds/music_menu.mp3')]
		private const MUSIC:Class;
		
		[Embed(source = '../../data/images/character/P1.png')]
		private const P1:Class;
		[Embed(source = '../../data/images/character/P2.png')]
		private const P2:Class;
		[Embed(source = '../../data/images/character/P3.png')]
		private const P3:Class;
		[Embed(source = '../../data/images/character/P4.png')]
		private const P4:Class;
		
		[Embed(source = '../../data/StencilStd.otf', fontFamily='mole_font')]
		private const FONT:Class;
		
		[Embed(source = '../../data/images/toucheEnter00.png')]
		private const ENTREE:Class;
		
		/**
		 * Constructeur.
		 */
		public function CMenu() 
		{						
			m_nPlayers = 1;
			m_aPlayers = new Array;
			m_aPlayerImage = new Array;
			m_aPlayerButton = new Array;
			
			Text.font = "mole_font";
			Text.size = 28;
			m_bChoosePlayer = false;
			m_aPlayerCurrentSkin = new Array;
			m_aPlayerSkinColor = new Array;			
		}
		
		/**
		 * Chargement des données.
		 */
		public function OnStart():void
		{
			// creation des assets.
			graphic = new Image(BACKGROUND);
			
			Main.SoundManager.PlayMusic(MUSIC, true, 2);
			var sfx:Sfx = new Sfx(VOICE_INTRO);
			sfx.play();
			
			Main.World.add(this);
						
			m_aButtons = new Array();
			
			// creation des boutons.
			var button:Text = null;
			m_CurrentButton = button = new Text("START", 850, 200);			
			m_aButtons.push(button);
			
			button = new Text("CREDITS", 850, 300);			
			m_aButtons.push(button);
			
			button= new Text("HOW TO", 850, 400);			
			m_aButtons.push(button);

			var i:Number = 0;
			for (i = 0; i < m_aButtons.length; i++)
			{
				button = m_aButtons[i];
				
				button.color = 0x000000;
				//button.scale = 3;
				button.centerOO();
				Main.World.addGraphic(button);
			}
			
			m_aButtonEntree = Main.World.addGraphic(new Image(ENTREE));
			m_aButtonEntree.x = 1024 - 100;
			m_aButtonEntree.y = 512 - 100;
			m_aButtonEntree.visible = true;
			
			m_iCurrentButton = 0;
			m_bRotateLeft = true;
			
			// Ajout des entrées clavier.
			Input.define("up", Key.Z, Key.UP, Key.E);
			Input.define("down", Key.S, Key.DOWN, Key.R);
			Input.define("up1", Key.E);
			Input.define("down1", Key.R);
			Input.define("up2", Key.O);
			Input.define("down2", Key.P);
			Input.define("up3", Key.X);
			Input.define("down3", Key.C);
			Input.define("up4", Key.B);
			Input.define("down4", Key.N);
			Input.define("select", Key.ENTER);
			Input.define("back", Key.ESCAPE, Key.BACKSPACE);
			
			m_MenuState = InMainMenu;
			
			// creation des têtes.
			m_aHeads = new Array();
			var head:Image = null;
			
			//head = new Image(DIDOU);			
			//m_aHeads.push(head);
			
			//head = new Image(NONO);
			//m_aHeads.push(head);
			
			//head = new Image(FAB);
			//m_aHeads.push(head);
			
			//head = new Image(CED);
			//m_aHeads.push(head);
			
			for (i = 0; i < m_aHeads.length; i++)
			{
				head = m_aHeads[i];
				head.centerOO();
				head.x = i % 2?650:100;
				head.y = 150 + (100 * i);
				head.visible = false;
				Main.World.addGraphic(head);
			}			
			
			// sélection des perso'
			m_aPlayerImage.push(new Image(P1));
			m_aPlayerImage.push(new Image(P2));
			m_aPlayerImage.push(new Image(P3));
			m_aPlayerImage.push(new Image(P4));
			
			var buttons:Array = new Array;
			buttons.push(new Image(P1_BUTTON));
			buttons.push(new Image(P2_BUTTON));
			buttons.push(new Image(P3_BUTTON));
			buttons.push(new Image(P4_BUTTON));
						
			for (i = 0; i < 4; i++)
			{												
				var entity:Entity = Main.World.addGraphic(m_aPlayerImage[i]);
				entity.width = 64;
				entity.height = 64;
				entity.y = 256 - 32;
				entity.x = (512 - 32) + (128 * i);
				entity.visible = false;
				entity.centerOrigin();
				m_aPlayerCurrentSkin[i] = i;
				m_aPlayerSkinColor[i] = -1;
				m_aPlayers.push(entity);
				
				var entityButton:Entity = Main.World.addGraphic(buttons[i]);
				entityButton.y = 256 + 64;
				entityButton.x = entity.x - 16;
				entityButton.visible = false;
				m_aPlayerButton.push(entityButton);
			}
			
			m_bStart = false;
		}
		
		/**
		 * Mise à jours de l'état.
		 */
		public function OnUpdate(): void
		{
			if (m_bStart)
				return;
				
			m_MenuState();
		}
		
		/**
		 * "Destruction" des données.
		 */
		public function OnEnd():void
		{			
			// suppression des entrés.
			Input.clear();
			
			// on supprime tout les elements du tableau
			while(m_aButtons.length)
				m_aButtons.pop();
				
			while (m_aHeads.length)
				m_aHeads.pop();			
			
			// suppression de tout les elements graphiques.
			Main.World.removeAll();				
		}
		
		/**
		 * Mise en pause
		 */
		public function OnPause():void
		{
			
		}
		
		/**
		 * Retour de pause
		 */
		public function OnResume():void
		{
			
		}
		
		private function InMainMenu():void
		{
			// deplacement dans le menu.
			if (Input.pressed("up"))
			{
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
				m_CurrentButton.angle = 0;
				
				if (m_iCurrentButton == 0)
					m_iCurrentButton = 2;
				else
					m_iCurrentButton--;
					
				m_CurrentButton = m_aButtons[m_iCurrentButton];
			}
			else if (Input.pressed("down"))
			{
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
				m_CurrentButton.angle = 0;
				
				if (m_iCurrentButton == 2)
					m_iCurrentButton = 0;
				else
					m_iCurrentButton++;
					
				m_CurrentButton = m_aButtons[m_iCurrentButton];
			}
			
			var button:Text = null;
			var i:Number = 0;
			// validation dans le menu.
			if (Input.pressed("select"))
			{
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_VALID]);
				
				// lancement du jeu.
				if (m_iCurrentButton == 0)
				{
					graphic = new Image(NB_PLAYER);
					
					// on cache le menu.
					i = 0;
					while(i < m_aButtons.length)
					{
						button = m_aButtons[i];
						button.visible = false;
						
						i++;
					}
										
					m_aPlayers[0].visible = true;
					m_aPlayerButton[0].visible = true;
					
					// changement d'état
					m_MenuState = InNbPlayers;
				}
				// les crédits.
				else if (m_iCurrentButton == 1)
				{					
					m_aButtonEntree.visible = false;
					graphic = new Image(CREDITS);
					
					// on cache le menu.
					i = 0;
					while(i < m_aButtons.length)
					{
						button = m_aButtons[i];
						button.visible = false;
						
						i++;
					}
					
					// on affiche les têtes.
					i = 0;
					while (i < m_aHeads.length)
					{
						var image:Image = m_aHeads[i];
						image.visible = true;
						image.angle = 0;
						
						i++;
					}
					
					// changement d'état.
					m_MenuState = InCredits;
				}
				// how to
				else
				{
					m_aButtonEntree.visible = false;
					graphic = new Image(HOWTO);
					
					// on cache le menu.
					for (var j:Number = 0; j < m_aButtons.length; j++)
					{
						var button2:Text = m_aButtons[j];
						button2.visible = false;
					}
					
					// changement d'état
					m_MenuState = InHowTo;
				}
			}
			
			// rotation du bouton.
			if (m_bRotateLeft && m_CurrentButton.angle < 20)
			{
				m_CurrentButton.angle += 0.25;
				
				if (m_CurrentButton.angle >= 20)
					m_bRotateLeft = false;
			}
			else if (!m_bRotateLeft && m_CurrentButton.angle > -20)
			{
				m_CurrentButton.angle -= 0.25;
				
				if (m_CurrentButton.angle <= -20)
					m_bRotateLeft = true;
			}
		}
		
		private function InCredits():void
		{
			var image:Image = null;
			var i:Number = 0;
			
			// retour au menu principal.
			if (Input.pressed("back"))
			{
				m_aButtonEntree.visible = true;
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_BACK]);
				graphic = new Image(BACKGROUND);
					
				// on affiche le menu.
				while(i < m_aButtons.length)
				{
					var button:Text = m_aButtons[i];
					button.visible = true;
						
					i++;
				}
					
				// on cache les têtes.
				i = 0;
				while (i < m_aHeads.length)
				{
					image = m_aHeads[i];
					image.visible = false;
						
					i++;
				}
					
				m_MenuState = InMainMenu;
			}
			
			// rotation des têtes.
			for (i = 0;  i < m_aHeads.length; i++)
			{
				image = m_aHeads[i];
				
				if (m_bRotateLeft && image.angle < 20)
				{
					image.angle += 0.25;
					
					if (image.angle >= 20)
						m_bRotateLeft = false;
				}
				else if (!m_bRotateLeft && image.angle > -20)
				{
					image.angle -= 0.25;
					
					if (image.angle <= -20)
						m_bRotateLeft = true;
				}
			}
		}
		
		private function InHowTo():void
		{
			// retour au menu principal.
			if (Input.pressed("back"))
			{
				m_aButtonEntree.visible = true;
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_BACK]);
				graphic = new Image(BACKGROUND);
					
				// on cache le menu.
				for (var i:Number = 0; i < m_aButtons.length; i++)
				{
					var button:Text = m_aButtons[i];
					button.visible = true;
				}
					
				m_MenuState = InMainMenu;
			}
		}
	
		private function InNbPlayers():void
		{			
			var i:int = 0;
			// retour au menu principal.
			if (Input.pressed("back"))
			{
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_BACK]);
				if (m_bChoosePlayer)		
				{
					graphic = new Image(NB_PLAYER);
					m_bChoosePlayer = false;
				}
				else
				{
					graphic = new Image(BACKGROUND);
					
					// on cache le menu.
					for (i = 0; i < m_aButtons.length; i++)
					{
						var button:Text = m_aButtons[i];
						button.visible = true;
					}
					
					m_MenuState = InMainMenu;
					
					for (i = 0; i < 4; i++)
					{
						m_aPlayers[i].visible = false;	
						m_aPlayerButton[i].visible = false;
						m_aPlayerCurrentSkin[i] = i;
						m_aPlayerSkinColor[i] = -1;
						m_aPlayers[i].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[i]];
					}
					m_nPlayers = 1;
				}
				
				return;
			}
			else if (Input.pressed("select"))
			{				
				if (m_bChoosePlayer)
				{							
					m_bStart = true;
					for (i = 0; i < m_nPlayers; i++)
					{						
						var controler:IControler;
						switch(i)
						{
							case 0: controler = new CPlayerControler; break;
							case 1: controler = new CPlayerControler2; break;
							case 2: controler = new CPlayerControler3; break;
							case 3: controler = new CPlayerControler4; break;
						}
						
						m_aPlayerSkinColor[m_aPlayerCurrentSkin[i]]++;
						Main.GameRules.AddPlayer(new CMole(0, 0, controler, m_aPlayerCurrentSkin[i], m_aPlayerSkinColor[m_aPlayerCurrentSkin[i]], i));
					}
					
					Main.SoundManager.StopMusic(true, 2, StartGame);
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_START]);
				}
				else
				{
					graphic = new Image(CHOOSE_PLAYER);
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_VALID]);
					m_bChoosePlayer = true;
				}
			}
			
			if (m_bChoosePlayer)
			{
				// changement de perso
				if (Input.pressed("up1"))
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[0]++;
					if (m_aPlayerCurrentSkin[0] > 3)
						m_aPlayerCurrentSkin[0] = 0;
						
					m_aPlayers[0].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[0]];
				}
				else if (Input.pressed("down1"))
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[0]--;
					if (m_aPlayerCurrentSkin[0] < 0)
						m_aPlayerCurrentSkin[0] = 3;
						
					m_aPlayers[0].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[0]];
				}
				
				if (Input.pressed("up2") && m_nPlayers > 1)
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[1]++;
					if (m_aPlayerCurrentSkin[1] > 3)
						m_aPlayerCurrentSkin[1] = 0;
						
					m_aPlayers[1].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[1]];
				}
				else if (Input.pressed("down2") && m_nPlayers > 1)
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[1]--;
					if (m_aPlayerCurrentSkin[1] < 0)
						m_aPlayerCurrentSkin[1] = 3;
						
					m_aPlayers[1].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[1]];
				}
				
				if (Input.pressed("up3") && m_nPlayers > 2)
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[2]++;
					if (m_aPlayerCurrentSkin[2] > 3)
						m_aPlayerCurrentSkin[2] = 0;
						
					m_aPlayers[2].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[2]];
				}
				else if (Input.pressed("down3") && m_nPlayers > 2)
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[2]--;
					if (m_aPlayerCurrentSkin[2] < 0)
						m_aPlayerCurrentSkin[2] = 3;
						
					m_aPlayers[2].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[2]];
				}
				
				if (Input.pressed("up4") && m_nPlayers > 3)
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[3]++;
					if (m_aPlayerCurrentSkin[3] > 3)
						m_aPlayerCurrentSkin[3] = 0;
						
					m_aPlayers[3].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[3]];
				}
				else if (Input.pressed("down4") && m_nPlayers > 3)
				{
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_NAVIG]);
					m_aPlayerCurrentSkin[3]--;
					if (m_aPlayerCurrentSkin[3] < 0)
						m_aPlayerCurrentSkin[3] = 3;
						
					m_aPlayers[3].graphic = m_aPlayerImage[m_aPlayerCurrentSkin[3]];
				}
			}
			else
			{
				// changement de nombre joueur
				if (Input.pressed("up"))
				{								
					m_nPlayers++;
					if (m_nPlayers > 4)
						m_nPlayers = 1;
						
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_SELECT_PLAYER + (m_nPlayers - 1)]);
				}
				else if (Input.pressed("down"))
				{
					m_nPlayers--;
					if (m_nPlayers < 1)
						m_nPlayers = 4;
						
					Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.UI_SELECT_PLAYER + (m_nPlayers - 1)]);
				}
								
				switch(m_nPlayers)
				{
					case 1:
						for (i = 1; i < 4; i++)
						{
							m_aPlayers[i].visible = false;
							m_aPlayerButton[i].visible = false;
						}
					break;
					
					case 2:
						for (i = 2; i < 4; i++)
						{
							m_aPlayers[i].visible = false;
							m_aPlayerButton[i].visible = false;
						}
						
						for (i = 0; i < 2; i++)
						{
							m_aPlayers[i].visible = true;
							m_aPlayerButton[i].visible = true;
						}
					break;
					
					case 3:
						for (i = 3; i < 4; i++)
						{
							m_aPlayers[i].visible = false;
							m_aPlayerButton[i].visible = false;
						}
						
						for (i = 0; i < 3; i++)
						{
							m_aPlayers[i].visible = true;					
							m_aPlayerButton[i].visible = true;
						}
					break;
					
					case 4:					
						for (i = 0; i < 4; i++)
						{
							m_aPlayers[i].visible = true;
							m_aPlayerButton[i].visible = true;
						}
					break;
				}
			}
		}
		
		/**
		 * Callback pour lancer le jeu
		 */
		public function StartGame():void
		{
			Main.GameStateManager.SetCurrentState(new CInGame());
			Main.GameRules.OnGameStart();
		}
		
		private var m_aButtons:Array; 		///< Liste de boutons.
		private var m_iCurrentButton:int; 	///< Index du bouton courant (0 - 2)
		private var m_CurrentButton:Text;   ///< Bouton courant.
		private var m_bRotateLeft:Boolean;	///< Rotation sur la gauche si vrai.
		private var m_MenuState:Function;   ///< Fonction appele pour l'update.
		private var m_aHeads:Array;			///< Les têtes de developpeur.
		private var m_nPlayers:int;			///< Nombre de joueur.
		private var m_aPlayers:Array;		///< Tableau de sprite de joueur.
		private var m_aPlayerImage:Array;
		private var m_bChoosePlayer:Boolean;
		private var m_aPlayerCurrentSkin:Array;
		private var m_aPlayerSkinColor:Array;
		private var m_bStart:Boolean;
		private var m_aPlayerButton:Array;
		private var m_aButtonEntree:Entity;
	}

}